// === DRIPBOX ADMIN SCRIPTS ===

// 1. COPIAR URLs DE AFILIADO (Mantido do original)
document.addEventListener("click", function(e) {
    if (e.target.classList.contains("dripbox-copy-admin")) {
        const fieldName = e.target.getAttribute("data-copy-target");
        const input = document.querySelector(`input[name="${fieldName}"]`);
        
        if (input && input.value.trim() !== "") {
            navigator.clipboard.writeText(input.value.trim()).then(() => {
                const original = e.target.textContent;
                e.target.textContent = "Copiado!";
                setTimeout(() => {
                    e.target.textContent = original;
                }, 1200);
            });
        }
    }
});


// 2. UPLOAD DE IMAGEM (Novo - Integração com WP Media Library)
jQuery(document).ready(function($){

    var mediaUploader;

    $('#dripbox_upload_btn').click(function(e) {
        e.preventDefault();

        // Se o uploader já foi criado, reabre ele
        if (mediaUploader) {
            mediaUploader.open();
            return;
        }

        // Cria o uploader do WordPress
        mediaUploader = wp.media.frames.file_frame = wp.media({
            title: 'Select Product Image',
            button: {
                text: 'Use this image'
            },
            library: {
                type: 'image' // Filtra só imagens
            },
            multiple: false // Só deixa escolher uma
        });

        // Quando uma imagem é selecionada
        mediaUploader.on('select', function() {
            var attachment = mediaUploader.state().get('selection').first().toJSON();
            
            // Coloca a URL no campo de texto
            $('#dripbox_img_input').val(attachment.url);

            // Atualiza o preview visualmente
            var previewHtml = '<img src="' + attachment.url + '" style="max-width:100%; height:auto; border-radius:8px; border:1px solid #ddd; margin-top:10px;">';
            $('#dripbox_img_preview_container').html(previewHtml);
        });

        // Abre a janela
        mediaUploader.open();
    });

});