
// === DRIPBOX v5.0 — All Interactions ===
document.addEventListener("DOMContentLoaded", function () {

    // --- Smooth toggle nos <details> ---
    document.querySelectorAll(".mini-affiliate-section details").forEach((el) => {
        el.addEventListener("toggle", () => {
            el.style.transition = "all 0.3s ease";
            el.style.background = el.open ? "#fafafa" : "transparent";
        });
    });

    // --- Hover visual nos botões ---
    document.querySelectorAll(".mini-affiliate-buttons a").forEach((btn) => {
        btn.addEventListener("mouseenter", () => {
            btn.style.boxShadow = "0 6px 14px rgba(0,0,0,0.25)";
            btn.style.transform = "translateY(-2px)";
        });
        btn.addEventListener("mouseleave", () => {
            btn.style.boxShadow = "0 3px 8px rgba(0,0,0,0.15)";
            btn.style.transform = "translateY(0)";
        });
    });

    // --- Smart Preload ---
    document.querySelectorAll(".mini-affiliate-buttons a").forEach((link) => {
        const preloadURL = () => {
            const url = link.getAttribute("href");
            if (url && !link.dataset.preloaded) {
                const preload = document.createElement("link");
                preload.rel = "preload";
                preload.as = "document";
                preload.href = url;
                document.head.appendChild(preload);
                link.dataset.preloaded = "true";
            }
        };
        link.addEventListener("mouseover", preloadURL, { passive: true });
        link.addEventListener("touchstart", preloadURL, { passive: true });
    });

    // --- Table Scroll (Event Delegation) ---
    document.addEventListener("click", function(e) {
        const btn = e.target.closest(".see-it-anchor");
        if (!btn) return;

        e.preventDefault();

        const productId = btn.getAttribute("data-product-id");
        const layouts = [
            'dripbox-product-' + productId,
            'dripbox-banner-' + productId,
            'dripbox-mag-' + productId,
            'dripbox-horizontal-' + productId
        ];

        let targetElement = null;
        for (let layoutId of layouts) {
            targetElement = document.querySelector("#" + layoutId);
            if (targetElement) break;
        }

        if (targetElement) {
            targetElement.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }
    });

    // --- Mag Layout Pro/Con Toggle ---
    document.querySelectorAll(".proscons-toggle").forEach(btn => {
        btn.addEventListener("click", function(e) {
            e.preventDefault();
            const parent = this.closest(".mini-pros, .mini-cons");
            const hiddenItems = parent.querySelectorAll(".proscons-hidden");
            hiddenItems.forEach(item => item.classList.add("show"));
            this.style.display = "none";
        });
    });

}); // ← FECHA DOMContentLoaded -----------------------------------------

console.log("BOTÕES EXISTEM?", document.querySelectorAll(".track-click").length);

// === CLICK ANALYTICS (FUNCIONA AGORA) ==================================
document.addEventListener("click", function(e) {
    const btn = e.target.closest(".track-click");
    if (!btn) return;

    const productId = btn.getAttribute("data-product");
    const type      = btn.getAttribute("data-type");

    console.log("TRACK CLICK →", { product: productId, type: type });

    fetch('/wp-json/dripbox/v1/track', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({
            product_id: productId,
            button: type
        })
    }).catch(err => console.log("TRACK ERROR:", err));
});

console.log("BOTÕES EXISTEM?", document.querySelectorAll(".track-click").length);

