<?php
/**
 * ================================================================
 * LASSO IMPORTER - ADMIN PAGE
 * ================================================================
 */

if (!defined('ABSPATH')) {
    exit;
}

class DripBox_Lasso_Importer_Admin {
    
    public function render() {
        $importer = DripBox_Lasso_Importer::get_instance();
        $has_lasso = $importer->detect_lasso();
        $count = $importer->count_lasso_products();
        
        ?>
        <div class="wrap dripbox-lasso-importer-wrap">
            <h1>🔄 Import from Lasso</h1>
            
            <?php if (!$has_lasso) : ?>
                <!-- NO LASSO DETECTED -->
                <div class="notice notice-warning">
                    <p><strong>No Lasso products detected.</strong></p>
                    <p>This tool imports products from Lasso plugin. If you have Lasso installed, make sure you have created some products first.</p>
                </div>
                
                <div class="dbx-import-card">
                    <h2>What does this tool do?</h2>
                    <p>The Lasso Importer allows you to migrate all your products from Lasso to DripBox in one click.</p>
                    
                    <div class="dbx-import-features">
                        ✅ <strong><?php echo $count; ?> products</strong> will be converted to DripBox format<br>
                        ✅ <strong>All product data</strong> preserved (titles, images, links, pros/cons)<br>
                        ✅ <strong>Shortcodes updated</strong> automatically in all posts<br>
                        ✅ <strong>Original Lasso products</strong> remain untouched (you can delete later)
                    </div>
                    
                    <div class="dbx-backup-warning">
                        ⚠️ <strong>Important:</strong> We strongly recommend creating a backup before importing.
                        <p style="margin-top: 10px;">
                            <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                                <input type="checkbox" id="dbx-backup-confirm" style="width: 18px; height: 18px;">
                                <span>I have backed up my database (or I accept the risk)</span>
                            </label>
                        </p>
                    </div>
                    
                    <p class="dbx-import-note">
                        ⚠️ <strong>Important:</strong> This process may take a few minutes depending on the number of products. 
                        Please don't close this page until the import is complete.
                    </p>
                    
                    <p><strong>Requirements:</strong> DripBox PRO license</p>
                </div>
                
            <?php else : ?>
                <!-- LASSO DETECTED -->
                <div class="dbx-import-info">
                    <div class="dbx-import-card">
                        <h2>✅ <?php echo $count; ?> Lasso products found!</h2>
                        <p>Ready to import your products to DripBox.</p>
                        
                        <div class="dbx-import-features">
                            ✅ <strong><?php echo $count; ?> products</strong> will be converted to DripBox format<br>
                            ✅ <strong>All product data</strong> preserved (titles, images, links, pros/cons)<br>
                            ✅ <strong>Shortcodes updated</strong> automatically in all posts<br>
                            ✅ <strong>Safe Mode</strong> - Requires backup confirmation<br>
                            ✅ <strong>Original Lasso products</strong> remain untouched (you can delete later)
                        </div>
                        
                        <p class="dbx-import-note">
                            ⚠️ <strong>Important:</strong> This process may take a few minutes depending on the number of products. 
                            Please don't close this page until the import is complete.
                        </p>
                        
                        <button id="dbx-start-import" class="button button-primary button-hero">
                            <span class="dashicons dashicons-download"></span>
                            Start Import (<?php echo $count; ?> products)
                        </button>
                        
                        <p style="margin-top: 20px; font-size: 13px; color: #666;">
                            This feature requires DripBox PRO license.
                        </p>
                    </div>
                </div>
                
                <!-- PROGRESS (hidden by default) -->
                <div id="dbx-import-progress" style="display:none;">
                    <h2>🔄 Importing products...</h2>
                    
                    <div class="dbx-progress-wrapper">
                        <div class="dbx-progress-bar">
                            <div id="dbx-progress-fill" class="dbx-progress-fill"></div>
                        </div>
                        
                        <div class="dbx-progress-info">
                            <p id="dbx-progress-text" style="font-weight: 600; margin: 10px 0;">
                                Collecting products...
                            </p>
                            <p id="dbx-progress-count" style="color: #666; margin: 5px 0;">
                                0 / <?php echo $count; ?> products imported
                            </p>
                        </div>
                    </div>
                    
                    <p style="color: #666; font-size: 13px; margin-top: 20px;">
                        ⏳ Please wait... This may take a few minutes.
                    </p>
                </div>
                
                <!-- RESULTS (hidden by default) -->
                <div id="dbx-import-results" style="display:none;">
                    <div class="notice notice-success" style="padding: 30px;">
                        <h2 style="margin-top: 0;">✅ Import Complete!</h2>
                        <p id="dbx-result-message" style="font-size: 15px;"></p>
                        
                        <p style="margin-top: 20px;">
                            <a href="<?php echo admin_url('edit.php?post_type=dripbox_product'); ?>" class="button button-primary">
                                View Imported Products
                            </a>
                            
                            <a href="<?php echo admin_url('edit.php'); ?>" class="button button-secondary">
                                View Your Posts
                            </a>
                        </p>
                        
                        <hr style="margin: 30px 0;">
                        
                        <h3>What's next?</h3>
                        <ol style="line-height: 1.8;">
                            <li>Check your imported products to make sure everything looks good</li>
                            <li>Visit your posts to see the new DripBox boxes in action</li>
                            <li>You can now safely deactivate and delete the Lasso plugin</li>
                            <li>Cancel your Lasso subscription and save money! 💰</li>
                        </ol>
                    </div>
                </div>
                
            <?php endif; ?>
        </div>
        <?php
    }
}