<?php
/**
 * ================================================================
 * DRIPBOX LINK CHECKER - ADMIN PAGE (MODERN UI V2)
 * ================================================================
 */

if (!defined('ABSPATH')) {
    exit;
}

class DripBox_Link_Checker_Admin_Page {
    
    public function render() {
        $db = DripBox_Link_Checker_DB::get_instance();
        $data = $db->get_results();
        
        ?>
        <div class="dripbox-admin-wrapper dbx-checker-modern">
            
            <div class="dbx-header-box">
                <div class="header-icon-wrap">
                    <span class="dashicons dashicons-admin-links"></span>
                </div>
                <div class="header-content">
                    <h1>DripBox Link Checker</h1>
                    <p>Monitor your affiliate links in real-time to protect your revenue.</p>
                </div>
            </div>
            
            
            <?php 
                $auto_scan = get_option('dripbox_auto_scan_enabled', 0);
                $email_alerts = get_option('dripbox_email_alerts_enabled', 0);
            ?>
            <div class="dbx-settings-card">
                <div class="settings-intro">
                    <h3>
                        <span class="dashicons dashicons-shield-alt" style="color:var(--dbx-orange);"></span>
                        Revenue Protection
                        <span class="pro-badge-small">PRO Feature</span>
                    </h3>
                    <p>Automatically scan your links every week and get notified if something breaks.</p>
                </div>
                
                <div class="toggles-wrap">
                    <div class="toggle-item">
                        <span class="toggle-label">Weekly Auto-Scan</span>
                        <label class="dbx-switch">
                            <input type="checkbox" id="dbx-toggle-scan" <?php checked(1, $auto_scan); ?>>
                            <span class="dbx-slider"></span>
                        </label>
                    </div>

                    <div class="toggle-item">
                        <span class="toggle-label">Email Alerts</span>
                        <label class="dbx-switch">
                            <input type="checkbox" id="dbx-toggle-email" <?php checked(1, $email_alerts); ?>>
                            <span class="dbx-slider"></span>
                        </label>
                    </div>
                </div>
            </div>
            
            
            <div class="dripbox-admin-grid stats-grid">
                <div class="dripbox-admin-card stat-card">
                    <div class="stat-icon icon-blue">📊</div>
                    <div class="stat-info">
                        <span class="stat-value" id="dbx-total-links"><?php echo $data['total_links']; ?></span>
                        <span class="stat-label">Total Links</span>
                    </div>
                </div>
                
                <div class="dripbox-admin-card stat-card">
                    <div class="stat-icon icon-red">❌</div>
                    <div class="stat-info">
                        <span class="stat-value" id="dbx-broken-count"><?php echo $data['broken_count']; ?></span>
                        <span class="stat-label">Broken</span>
                    </div>
                </div>
                
                <div class="dripbox-admin-card stat-card">
                    <div class="stat-icon icon-orange">⚠️</div>
                    <div class="stat-info">
                        <span class="stat-value" id="dbx-risky-count"><?php echo $data['risky_count']; ?></span>
                        <span class="stat-label">Risky</span>
                    </div>
                </div>
                
                <div class="dripbox-admin-card stat-card">
                    <div class="stat-icon icon-green">✅</div>
                    <div class="stat-info">
                        <span class="stat-value" id="dbx-ok-count"><?php echo $data['ok_count']; ?></span>
                        <span class="stat-label">Working</span>
                    </div>
                </div>
            </div>
            
            <div class="dbx-control-panel">
                <div class="control-left">
                    <button id="dbx-start-scan" class="dripbox-admin-btn btn-orange">
                        <span class="dashicons dashicons-update" style="margin-top:4px;"></span> Scan All Links
                    </button>
                    <?php if ($data['last_scan']) : ?>
                        <span class="last-scan-info">
                            Last scan: <?php echo human_time_diff(strtotime($data['last_scan']), current_time('timestamp')); ?> ago
                        </span>
                    <?php endif; ?>
                </div>
                <div class="control-right">
                    <button id="dbx-clear-results" class="btn-white">
                        <span class="dashicons dashicons-trash"></span> Clear Results
                    </button>
                </div>
            </div>
            
            <div id="dbx-progress-container" style="display:none;" class="modern-progress-wrap">
                <div class="dbx-progress-header">
                    <span id="dbx-progress-text">Scanning links...</span>
                    <span id="dbx-progress-count">0 / 0</span>
                </div>
                <div class="dbx-progress-bar">
                    <div id="dbx-progress-fill" class="dbx-progress-fill"></div>
                </div>
            </div>
            
            <div id="dbx-results-container">
                <?php if (!empty($data['results'])) : ?>
                    <?php $this->render_results_table($data['results']); ?>
                <?php else : ?>
                    <div class="dbx-empty-state-modern">
                        <div class="empty-icon">🔍</div>
                        <h2>No scan results yet</h2>
                        <p>Click "Scan All Links" to check all affiliate links on your site.</p>
                    </div>
                <?php endif; ?>
            </div>
        </div>

        <?php
    }
    
    /**
     * Render results as Modern List
     * (Atualizado com Shortcode Copy e botão Fix Link)
     */
    private function render_results_table($results) {
        ?>
        <div class="dbx-modern-tabs">
            <button class="dbx-tab active" data-filter="all">All Links <span class="badge"><?php echo count($results); ?></span></button>
            <button class="dbx-tab" data-filter="broken">Broken <span class="badge badge-red"><?php echo $this->count_status($results, 'broken'); ?></span></button>
            <button class="dbx-tab" data-filter="risky">Risky <span class="badge badge-orange"><?php echo $this->count_status($results, 'risky'); ?></span></button>
            <button class="dbx-tab" data-filter="ok">Working <span class="badge badge-green"><?php echo $this->count_status($results, 'ok'); ?></span></button>
        </div>
        
        <div class="dbx-link-list-header">
            <div class="col-status">Status</div>
            <div class="col-main">URL Info</div>
            <div class="col-details">Details</div>
            <div class="col-actions">Actions</div>
        </div>

        <div class="dbx-link-list">
            <?php foreach ($results as $result) : ?>
                <div class="dbx-link-row dbx-row-<?php echo esc_attr($result['status']); ?>" data-status="<?php echo esc_attr($result['status']); ?>">
                    
                    <div class="dbx-col col-status">
                        <?php echo $this->get_status_icon($result['status']); ?>
                    </div>

                    <div class="dbx-col col-main">
                        <div class="url-line">
                            <a href="<?php echo esc_url($result['url']); ?>" target="_blank" class="main-link">
                                <?php echo esc_html($this->truncate_url($result['url'], 60)); ?>
                            </a>
                            <span class="http-badge"><?php echo esc_html($result['http_code']); ?></span>
                        </div>
                        <div class="post-line">
                            Found in: <a href="<?php echo esc_url($result['post_url']); ?>" target="_blank"><strong><?php echo esc_html($result['post_title']); ?></strong></a>
                            
                            <span class="dbx-shortcode-badge" title="Click to copy shortcode" onclick="navigator.clipboard.writeText('[dripbox id=&quot;<?php echo $result['post_id']; ?>&quot;]'); alert('Shortcode copied!');">
                                [dripbox id="<?php echo $result['post_id']; ?>"]
                            </span>
                        </div>
                    </div>

                    <div class="dbx-col col-details">
                         <span class="status-pill pill-<?php echo esc_attr($result['status']); ?>">
                            <?php echo esc_html($result['label']); ?>
                        </span>
                    </div>

                   <div class="dbx-col col-actions">
                        <button class="btn-small-outline dbx-recheck-link" data-url="<?php echo esc_attr($result['url']); ?>">
                           <span class="dashicons dashicons-update"></span> Recheck
                        </button>

                        <?php if ($result['status'] !== 'ok') : ?>
                            <a href="<?php echo admin_url('post.php?post=' . $result['post_id'] . '&action=edit'); ?>" target="_blank" class="dbx-fix-btn button">
                                FIX LINK
                            </a>
                        <?php endif; ?> 
                    </div> </div> <?php endforeach; ?>
        </div> <?php
    }
    
    private function get_status_icon($status) {
        // Ícones SVG minimalistas para combinar com o tema SaaS
        switch($status) {
            case 'ok': return '<div class="status-dot dot-green"></div>';
            case 'broken': return '<div class="status-dot dot-red"><span class="dashicons dashicons-no"></span></div>';
            case 'risky': return '<div class="status-dot dot-orange"><span class="dashicons dashicons-warning"></span></div>';
            default: return '';
        }
    }
    
    private function count_status($results, $status) {
        return count(array_filter($results, function($item) use ($status) {
            return $item['status'] === $status;
        }));
    }
    
    private function truncate_url($url, $length = 60) {
        if (strlen($url) <= $length) return $url;
        return substr($url, 0, $length) . '...';
    }
}