<?php
/**
 * ================================================================
 * DRIPBOX LINK CHECKER - MAIN LOADER
 * ================================================================
 */

if (!defined('ABSPATH')) {
    exit;
}

class DripBox_Link_Checker {
    
    private static $instance = null;
    
    public static function get_instance() {
        if (self::$instance === null) {
            self::$instance = new self();
        }
        return self::$instance;
    }
    
    private function __construct() {
        $this->load_dependencies();
        $this->init_hooks();
    }
    
    private function load_dependencies() {
        // Database handler
        require_once plugin_dir_path(__FILE__) . 'database/class-db.php';
        
        // Admin components (only in admin)
        if (is_admin()) {
            require_once plugin_dir_path(__FILE__) . 'admin/class-scanner.php';
            require_once plugin_dir_path(__FILE__) . 'admin/class-admin-page.php';
            require_once plugin_dir_path(__FILE__) . 'admin/class-ajax.php';
        }
    }
    
    private function init_hooks() {
        if (!is_admin()) {
            return;
        }
        
        add_action('admin_menu', [$this, 'register_admin_menu']);
        add_action('admin_enqueue_scripts', [$this, 'enqueue_assets']);
        
        // Initialize AJAX handlers
        DripBox_Link_Checker_AJAX::get_instance();
    }
    
    public function register_admin_menu() {
        add_submenu_page(
            'edit.php?post_type=dripbox_product',
            'Link Checker',
            'Link Checker',
            'manage_options',
            'dripbox-link-checker',
            [$this, 'render_admin_page']
        );
    }
    
    public function render_admin_page() {
        $admin_page = new DripBox_Link_Checker_Admin_Page();
        $admin_page->render();
    }
    
    public function enqueue_assets($hook) {
        // Only load on our page
        if ($hook !== 'dripbox_product_page_dripbox-link-checker') {
            return;
        }
        
        // CSS
        wp_enqueue_style(
            'dripbox-link-checker-admin',
            plugins_url('assets/admin-style.css', __FILE__),
            [],
            '1.0.0'
        );
        
        // JS
        wp_enqueue_script(
            'dripbox-link-checker-admin',
            plugins_url('assets/admin-script.js', __FILE__),
            ['jquery'],
            '1.0.0',
            true
        );
        
        // Pass data to JS
        wp_localize_script('dripbox-link-checker-admin', 'dripboxLinkChecker', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'nonce' => wp_create_nonce('dripbox_link_checker'),
            'server_url' => 'https://getdripbox.com/wp-json/dripbox/v1/check-link',
            'license_key' => get_option('dripbox_license_key', '')
        ]);
    }
}

// Initialize
function dripbox_link_checker_init() {
    DripBox_Link_Checker::get_instance();
}
add_action('plugins_loaded', 'dripbox_link_checker_init');